<?php
/***************************************************************\
 *  AddSpoiler plugin pour Dotclear 2                          *
 *  Keul <keul at keul dot fr>                                 *
 *  Licence GNU GPL v2                                         *
\***************************************************************/

if (!defined('DC_CONTEXT_ADMIN')) { return; }

$core->addBehavior('coreAfterPostContentFormat',array('dcaddSpoiler','addSpoiler'));
$core->addBehavior('adminBlogPreferencesForm',array('dcaddSpoiler','addSpoilerPreferencesForm'));
$core->addBehavior('adminBeforeBlogSettingsUpdate',array('dcaddSpoiler','addSpoilerSettingsUpdate'));

function dcplugaddSpoiler($txt) {
  //remplacement de [/spoiler] suite au passage dans le traducteur Wiki
	$txt=str_ireplace('<a href="/spoiler" title="/spoiler">/spoiler</a>','[/spoiler]',$txt);
  //remplacement de [spoiler( xxx)] suite au passage dans le traducteur Wiki
	$txt=preg_replace('/<a href="spoiler[^\"]*" title="spoiler([^\"]*)([^>]*)>(.*?)<\/a>/is','[spoiler$1]',$txt);
	//conversion HTML avec ajout de javascript
	$txt=preg_replace('/\[spoiler( [^\]]*)?\](.*?)\[\/spoiler\]/is','</p><div class="addspoiler"><a onclick="javascript:this.parentNode.childNodes[0].style.display=\'none\';this.parentNode.childNodes[1].style.display=\'\';this.parentNode.childNodes[2].style.display=\'\';return false;" href="#">'.__('Display').'$1</a><a style="display:none;" onclick="this.parentNode.childNodes[0].style.display=\'\';this.parentNode.childNodes[1].style.display=\'none\';this.parentNode.childNodes[2].style.display=\'none\';return false;" href="#">'.__('Hide').'$1</a><div style="display:none;"><p>$2</p></div></div><p>',$txt);
	return $txt;
}

class dcaddSpoiler {
	public static function addSpoiler ($arr) {
    //on traite la version qui va être cachée
		$arr['excerpt_xhtml']=dcplugaddSpoiler($arr['excerpt_xhtml']);
		$arr['content_xhtml']=dcplugaddSpoiler($arr['content_xhtml']);
	}
	public static function addSpoilerPreferencesForm($core,$settings) {
		echo
		'<fieldset><legend>addSpoiler</legend>'.
		'<p><label class="classic">'.__('Usage&nbsp: [spoiler]text[/spoiler] or [spoiler description]text[/spoiler]').'</label></p>'.
		'<p><label class="classic">'.__('Custom skin:').' '.
		form::combo('addSpoiler_css',array(__('Style 1')=>'margin:1em;padding:0.5em;border:1px dotted #CCCCCC;border-left:2px solid #CCCCCC;background:#F5F5F5;',__('Style 2')=>'margin:1em;padding:0.5em;border:1px dotted #33BB33;border-left:2px solid #33BB33;background:#F2FFF2;',__('Style 3')=>'margin:0.5em;padding:0.5em;border:1px dotted #AAAAAA;',__('custom')=>'disable'),$settings->addSpoiler_css).
		'</label></p>'.
		'<p class="form-note">'.__('Select "custom" if you already have defined class "addspoiler" in your cascaded stylesheet.').'</p>'.
		'</fieldset>';
	}
	
	public static function addSpoilerSettingsUpdate($settings) {
		$settings->setNameSpace('addSpoiler');
		$settings->put('addSpoiler_css',$_POST['addSpoiler_css'],'string');		
		$settings->setNameSpace('system');
	}
}

?>