<?php
class dcDotpollHtml
{
      private $core;
      private $messages;
      private $default_tab;
      private $location;
      private $script;
      private $p_url;
      private $p_name;

      public function __construct(&$core,$p_url,$p_name)
      {
            $this->core        =& $core;
            $this->messages    =  array();
            $this->default_tab =  null;
            $this->location    =  array();
            $this->p_url       =  $p_url;
            $this->p_name      =  $p_name;
            $this->script      =  array();
      }
      
      public function addMessage($msg)
      {
            $this->messages[] = $msg;
      }
      
      public function addLocation($loc)
      {
            $this->location[] = $loc;
      }
      
      public function setDefaultTab($tab)
      {
            $this->default_tab = $tab;
      }
      
      private function openTab($id,$title)
      {
            echo
            '<div class="multi-part" id="'.$id.'" '.
            'title="'.$title.'">';
      }
      
      private function closeTab()
      {
            echo '</div>';
      }
      
      private function loadScript($script)
      {
            $this->script[] = $script;
      }
      
      private function header()
      {
            // Title / JS
            echo
            '<html><head><title>'.$this->p_name.'</title>'.
            (($this->default_tab !== null)?dcPage::jsPageTabs($this->default_tab):'').
            dcPage::jsToolMan();
            
            foreach($this->script as $sc)
                  echo '<script type="text/javascript" src="'.$sc.'"></script>';
            
            echo
            '</head><body>';

            // Location
            echo '<h2>'.html::escapeHTML($this->core->blog->name);
            if(count($this->location) > 0)
            {
                  echo
                  ' &gt; <a href="'.$this->p_url.'" title="'.html::escapeHTML($this->p_name).'">'.
                  html::escapeHTML($this->p_name).'</a>';

                  foreach($this->location as $lc)
                  {
                        if(is_array($lc))
                          echo
                          ' &gt; <a href="'.$lc[0].'" title="'.html::escapeHTML($lc[1]).'">'.
                          html::escapeHTML($lc[1]).
                          '</a>';
                        else
                          echo
                          ' &gt; '.html::escapeHTML($lc);
                  }
            }
            else
            {
                  echo
                  ' &gt; '.html::escapeHTML($this->p_name);
            }
            echo '</h2>';
            
            // Show messages
            foreach($this->messages as $message)
                  echo '<p class="message">'.html::escapeHTML($message).'</p>';
      }
      
      private function footer()
      {
            // Footer
            echo '</body></html>';
      }
      
      public function homePage(&$manager)
      {
            // Header
            $this->header();
            
            // Polls list
            
            $this->openTab('pollslist',__('My polls'));
            
          
            if(!$manager->pollsCount())
              echo '<p>'.__('No poll found.').'</p>';
            else
            {
              echo
              '<form action="'.$this->p_url.'" method="post" onsubmit="return confirm(\''.
              __('Do you realy want to delete selected polls?').
              '\')">'.
              $this->core->formNonce().
              '<table class="maximal"><tr>'.
              '<th>'.__('Title').'</th>'.
              '<th>'.__('Date').'</th>'.
              '<th>'.__('Author').'</th>'.
              //'<th>'.__('Status').'</th>'.
              '<th>'.__('Id').'</th>'.
              '</tr>';
              
              foreach($manager->getPolls() as $poll)
              {
                echo
                '<tr class="line">'.
                  '<td>'.form::checkbox('poll[]', $poll->id).' '.
                  '<a href="'.$this->p_url.'&action=wievpoll&pollid='.$poll->id.'" '.
                  'title="'.__('Wiev or edit poll details').'">'.
                  html::escapeHTML($poll->title).'</a></td>'.
                  '<td>'.$poll->cdate.'</td>'.
                  '<td>'.html::escapeHTML($poll->author).'</td>'.
                  //'<td><img src="images/check-'.($poll->status['id']?'on':'off').'.png"'.
                  //' alt="'.html::escapeHTML($poll->status['text']).'" '.
                  //'title="'.html::escapeHTML($poll->status['text']).'" />'.
                  '</td>'.
                  '<td>'.$poll->id.'</td>'.
                '</tr>';
              }

              echo '</table>';
              
              echo
              '<div class="two-cols">'.
              '<p class="col checkboxes-helpers"></p><p class="col right">'.
              ' <input type="hidden" name="action" value="remove" />'.
              ' <input type="submit" name="ok" value="'.__('Delete selected polls').'" />'.
              '</p></div></form>';
            }
            
            $this->closeTab();
            
            // New poll form
            
            $this->openTab('newpoll',__('New poll'));
            
            echo 
            '<form action="'.$this->p_url.'&action=add" method="post">'.
            '<fieldset><legend>'.__('Poll title').'</legend>'.
            '<p><label>'.__('Title wich will appear on the top of your new poll: ').
            form::field('title', 50, 255).
            '</label></fieldset>'.
            '<p><input type="submit" name="save" value="'.
            __('Save').
            '" /></p>'.
            $this->core->formNonce().
            '</form>';
            
            $this->closeTab();
            
            // Configuration
            
            $this->openTab('config',__('Configuration'));
            
            echo '<form action="'.$this->p_url.'&action=saveconfig" method="post">'.
                 $this->core->formNonce().
                 '<fieldset><legend>'.__('Identification method').'</legend>'.
                 '<div class="two-cols">'.
                 '<p class="col"><label class="classic">'.
                 form::checkbox('cookieid', 1, $manager->dotpoll_cookie_id).
                 __('Enable cookie identification').'</label></p>'.
                 '<p class="col"><label class="classic">'.
                 form::checkbox('ipid', 1, $manager->dotpoll_ip_id).
                 __('Enable IP identification').'</label></p>'.
                 '</div></fieldset>'.
                 '<p><input type="submit" name="save" value="'.__('Save').'" /></p>'.
                 '</form>';
            
            $this->closeTab();
            
            // Footer
            $this->footer();
      }
      
      public function pollPage(&$poll)
      {
            // Script
            $this->loadScript('index.php?pf=dotpoll/script/option-order.js');
      
            // Header
            $this->header();
            
            // Poll infos
            $this->openTab('pollinfos',__('Poll'));
            
            echo
            '<form action="'.$this->p_url.'&action=update&pollid='.$poll->id.'" method="post">'.
            '<fieldset><legend>'.__('Poll title').'</legend>'.
            '<p><label>'.__('Title wich will appear on the top of your new poll: ').
            form::field('title', 50, 255,html::escapeHTML($poll->title)).
            '</label></p>'.
            '</fieldset>'.
            '<p><input type="submit" name="update" value="'.__('Update').'" /></p>'.
            $this->core->formNonce().
            '</form>';

            $this->closeTab();

            // Options list
                 
            $this->openTab('optionslist',__('Options list'));
            
            if($poll->optionsCount() == 0)
            {
                  echo '<p>'.__('No option found.').'</p>';
            }
            else
            {
                  echo
                  '<form action="'.$this->p_url.'&action=updateoption&pollid='.$poll->id.'" method="post">'.
                  $this->core->formNonce().
                  '<table class="maximal"><thead><tr><th colspan="2">'.__('Option').'</th></tr></thead><tbody id="options-list">';
                  
                  $i=1;
                  foreach($poll->options as $id => $option)
                  {
                        echo
                        '<tr class="line" id="op'.$id.'">'.
                        '<td class="handle minimal">'.form::field(array('order['.$id.']'),2,5,$i++).'</td>'.
                        '<td>'.form::checkbox('option[]', $id).
                        '<a href="'.$this->p_url.'&action=wievoption&pollid='.$poll->id.'&optionid='.$id.'" '.
                        'title="'.__('Wiev or edit option').'">'.
                        html::escapeHTML($option).
                        '</a></td>'.
                        '</tr>';
                  }
                  echo '</tbody></table>'.
                       form::hidden('options_order','').
                       '<div class="two-cols">'.
                       '<p class="col"><input type="submit" name="saveorder" value="'.__('Save order').'" /></p>'.
                       '<p class="col right"><input type="submit" name="delete" value="'.
                       __('Delete selected options').
                       '" /></p></div></form>';
            }

            $this->closeTab();

            // New option form

            $this->openTab('newoption',__('New option'));
                 
            echo  '<form action="'.$this->p_url.'&action=addoption&pollid='.$poll->id.'" method="post">'.
                  $this->core->formNonce().
                  '<fieldset><legend>'.__('New option').'</legend>'.
                  '<p><label>'.__('Option text:').
                  form::field('option',40,255).
                  '</label></p>'.
                  '</fieldset><input type="submit" name="save" value="'.__('Save').'" /></form>';

            $this->closeTab();           
            
            // Results
            
            $this->openTab('results',__('Results'));
            
            if($poll->optionsCount() > 0)
            {
                  echo '<table class="maximal"><tr><th>'.
                       __('Option').
                       '</th><th>'.
                       __('Percent').
                       '</th><th>'.
                       __('Vote(s)').
                       '</th></td>';

                  $options = $poll->options;
                  foreach($poll->results as $id => $value)
                  {
                        echo '<tr class="line">'.
                             '<td>'.html::escapeHTML($options[$id]).'</td>'.
                             '<td>'.$value['per'].' %</td>'.
                             '<td>'.$value['nb'].'</td>'.
                             '</tr>';
                  }
             
                  echo '</table>'.
                       '<div class="two-cols">'.
                       '<p class="col">'.__('Number of votes:').' '.$poll->votes.'</p>'.
                       '<form action="'.$this->p_url.'&action=clearreasults&pollid='.$poll->id.'" method="post">'.
                       $this->core->formNonce().
                       '<p class="col right"><input type="submit" name="reset" value="'.__('Reset results').'" /></p>'.
                       '</form>'.
                       '</div>';
            }
            else
                  echo '<p>'.__('No option found.').'</p>';
            
            $this->closeTab();
            
            // Footer
            $this->footer();
      }
      
      public function optionPage($poll,$option)
      {
            // Header
            $this->header();
            
            // Update option form
            echo
            '<form action="'.$this->p_url.'&action=wievoption&pollid='.$poll->id.'&optionid='.$option[0].'" method="post">'.
            $this->core->formNonce().
            '<fieldset><legend>'.__('Edit option').'</legend>'.
            '<p><label>'.__('Option text:').form::field('option',40,255,html::escapeHTML($option[1])).'</label></p>'.
            '</fieldset><input type="submit" name="update" value="'.__('Update').'" /></form>';
                  
            // Footer
            $this->footer();
      }
}

?>
