<?php
// 429 Lignes de code = 1 soir
class dcDotpoll
{
      private $infos;

      private $option_table;
      private $result_table;
      private $poll_table;
      
      private $db;
      private $blog_id;
      
      private $options_loaded;
      private $results_loaded;
      
      private $config;
      
      private $aStatus;
      
      public function __construct(&$core)
      {
            $this->db               =& $core->con;
            $this->blog_id          =  $core->blog->id;

            $this->option_table     =  $core->prefix.'dotpoll_option';
            $this->result_table     =  $core->prefix.'dotpoll_result';
            $this->poll_table       =  $core->prefix.'dotpoll';

            $this->infos            =  array();
            $this->infos['title']   =  '';
            $this->infos['options'] =  array();
            $this->infos['results'] =  array();
            $this->infos['id']      =  null;
            $this->infos['votes']   =  null;
            $this->infos['status']  =  0;
            $this->infos['cdate']   =  time();
            $this->infos['author']  =  $core->auth->userID();
            
            $this->options_loaded   =  false;
            $this->results_loaded   =  false;
            
            $this->config           =& $core->blog->settings;
            
            $this->aStatus[1]        = __('Published');
            $this->aStatus[0]        = __('Off line');
      }
      
      public function __set($key,$value)
      {
            switch($key)
            {
                  case 'options':
                  case 'results':
                        throw new Exception(sprintf(__('Illegal access to %s member.'),$key));
                        break;
            }
            $this->infos[$key] = $value;
      }
      
      public function __get($key)
      {
            switch($key)
            {
                  case 'options':
                        $this->loadOptions();
                        break;
                  case 'results':
                  case 'votes':
                        $this->loadResults();
                        break;
                  case 'status':
                        return array( 'id'   => $this->infos['status'],
                                      'text' => $this->aStatus[$this->infos['status']]);
                        break;
            }
            if(isset($this->infos[$key]))
                  return $this->infos[$key];
            else
                  return null;
      }
      
      public function removeOption($id)
      {
            if($this->options_loaded)
                  unset($this->infos['options'][$id]);

            $this->clearResult($id);

            return
            $this->db->execute('DELETE FROM '.$this->option_table.
                               ' WHERE option_id = \''.$this->db->escape($id).'\''.
                               ' AND option_poll_id = \''.$this->infos['id'].'\'');
      }
      
      public function updateOption($id,$value)
      {
            if($this->options_loaded)
                  $this->infos['options'][$id] = $value;
      
            return
            $this->db->execute('UPDATE '.$this->option_table.
                               ' SET option_text = \''.
                               $this->db->escape($value).'\' '.
                               'WHERE option_id =  \''.$this->db->escape($id).'\''.
                               ' AND option_poll_id = \''.$this->infos['id'].'\'');
      }
      
      public function setOptionOrder($id,$order)
      {
            return
            $this->db->execute('UPDATE '.$this->option_table.' '.
                               'SET option_position = \''.$this->db->escape($order).'\' '.
                               'WHERE option_id = \''.$this->db->escape($id).'\'');
      }
      
      public function addOption($value)
      {
            $id = $this->getFreeId($this->option_table,'option_id');
            
            if($this->options_loaded)
                  $this->infos['options'][$id] = $value;
            
            return
            $this->db->execute('INSERT INTO '.$this->option_table.
                               ' (option_id,option_text,option_position,option_poll_id) VALUES ( \''.$id.
                               '\', \''.$this->db->escape($value).'\', \'0\', \''.$this->infos['id'].'\')');
      }
      
      public function addResult($optionId)
      {
            if($this->userHasResult()) return false;
            
            $id = $this->getFreeId($this->result_table,'result_id');

            if($this->config->dotpoll_ip_id)
                  $ip = $this->db->escape(http::realIP());
            else $ip = '';

            $this->db->execute('INSERT INTO '.$this->result_table.' ('.
                               'result_id,result_option_id,result_user_ip,result_poll_id'.
                               ')VALUES(\''.$id.'\',\''.$this->db->escape($optionId).'\', \''.
                               $ip.'\',\''.$this->infos['id'].'\')');
            
            if($this->config->dotpoll_cookie_id)
            {
                  if(isset($_COOKIE['dotpollListDone']))
                        $list = explode(',',$_COOKIE['dotpollListDone']);
                  else
                        $list = array();
                  $list[] = $this->infos['id'];
                  setcookie('dotpollListDone',implode(',',$list),time()+60*60*24*30);
            }
            
      }
      
      function userHasResult()
      {
            if($this->config->dotpoll_cookie_id)
            {
                  if(isset($_COOKIE['dotpollListDone']))
                        $list = explode(',',$_COOKIE['dotpollListDone']);
                  else
                        $list = array();
                  if(in_array($this->infos['id'],$list)) return true;
            }
            
            if($this->config->dotpoll_ip_id)
            {
                  $rc =
                  $this->db->select('SELECT result_user_ip FROM '.$this->result_table.' '.
                                    'WHERE result_poll_id = \''.$this->infos['id'].'\' '.
                                    'AND result_user_ip = \''.$this->db->escape($_SERVER['REMOTE_ADDR']).'\'');
                  return ($rc->count() != 0);
            }

            return false;
      }
      
      public function clearResult($id=null)
      {
            $sql = 'DELETE FROM '.$this->result_table.
                   ' WHERE result_poll_id = \''.$this->infos['id'].'\'';

            if($id !== null)
                  $sql .= ' AND result_option_id = \''.$this->db->escape($id).'\'';
            
            return
            $this->db->execute($sql);
      }
      
      public function save()
      {
            if($this->infos['id'] == null)
            {
                  $this->infos['id'] = $this->getFreeId($this->poll_table,'poll_id');
                  return
		      $this->db->execute('INSERT INTO '.
                                     $this->poll_table.
                                     ' (poll_id,poll_title,poll_blog,poll_status,poll_cdate,poll_user) VALUES ( \''.
                                     $this->infos['id'].'\',\''.
                                     $this->db->escape($this->infos['title']).'\',\''.
                                     $this->db->escape($this->blog_id).'\', \''.
                                     $this->db->escape($this->infos['status']).'\', \''.
                                     time().'\', \''.
                                     $this->infos['author'].
                                     '\')');
            }
            else
            {
                  $this->db->execute('UPDATE '.$this->poll_table.' SET '.
                                     ' poll_title = \''.
                                     $this->db->escape($this->infos['title']).
                                     '\', poll_status = \''.
                                     $this->db->escape($this->infos['status']).
                                     '\' WHERE poll_id = \''.$this->infos['id'].'\' '.
                                     ' AND poll_blog = \''.$this->db->escape($this->blog_id).'\'');
            }
      }
      
      public function remove()
      {
            $this->clearResult();
            $this->loadOptions();
            foreach($this->infos['options'] as $id => $value)
                  $this->removeOption($id);
            return
            $this->db->execute('DELETE FROM '.$this->poll_table.
                               ' WHERE poll_id = \''.$this->infos['id'].'\''.
                               ' AND poll_blog = \''.$this->blog_id.'\'');
      }
      
      public function optionsCount()
      {
            $this->loadOptions();
            return count($this->infos['options']);
      }
      
      private function loadOptions()
      {
            if($this->options_loaded) return true;
            if($this->infos['id'] == null) return false;
            
            $record = $this->db->select('SELECT * FROM '.
                                        $this->option_table.
                                        ' WHERE option_poll_id = \''.
                                        $this->db->escape($this->infos['id']).'\' '.
                                        'ORDER BY option_position ASC');
            while($record->fetch())
                  $this->infos['options'][$record->option_id] = $record->option_text;
                  
            return true;
      }
      
      private function loadResults()
      {
            if($this->results_loaded) return true;
            if($this->infos['id'] == null) return false;
            
            $this->loadOptions();
            
            $rec = 
            $this->db->select('SELECT COUNT(result_id) AS total, '.
                              'result_option_id FROM '.$this->result_table.' '.
                              'WHERE result_poll_id = \''.
                              $this->infos['id'].
                              '\' GROUP BY result_option_id');
            
            $rList = array();
            $sum = 0;
            while($rec->fetch())
            {
                  $rList[$rec->result_option_id] = $rec->total;
                  $sum += $rec->total;
            }
            
            $fList = array();
            foreach($this->infos['options'] as $id => $value)
            {
                  if(isset($rList[$id]))
                  {
                        $fList[$id] = array('per' => round($rList[$id]/$sum*100,2), 'nb' => $rList[$id]);
                  }
                  else
                        $fList[$id] = array('per' => 0, 'nb' => 0);
            }
            
            $this->infos['results'] = $fList;
            $this->infos['votes'] = $sum;
            return true;
      }
      
      private function getFreeId($table,$field)
      {
            $rs = $this->db->select('SELECT MAX('.$field.') FROM '.
                                    $table);
            return (integer) $rs->f(0) + 1;
      }
}
?>
