<?php
class dcDotpolls
{
      private $polls;
      private $pollsLoaded;
      
      private $poll_table;
      
      private $blog_id;
      private $db;
      private $core;
      
      private $config;
      
      private $filters;

      public function __construct(&$core)
      {
            $this->polls        =  array();
            $this->pollsLoaded  =  false;
            
            $this->poll_table   =  $core->prefix.'dotpoll';
            
            $this->blog_id      =  $core->blog->id;
            $this->db           =& $core->con;
            $this->core         =& $core;
            
            $this->config       =& $core->blog->settings;
            
            $this->filters      =  array();
      }
      
      public function getPolls()
      {
            $this->loadPolls();
            return $this->polls;
      }
      
      public function __get($key)
      {
            $this->config->setNamespace('dotpoll');
            return $this->config->$key;
      }
      
      public function __set($key,$value)
      {
            $this->config->setNamespace('dotpoll');
            $this->config->put($key,$value);
      }
      
      public function getPoll($id)
      {
            if($this->pollsLoaded)
            {
                  if(isset($this->polls[$id]))
                        return $this->polls[$id];
                  else
                        throw new Exception(sprintf(__('Poll identified by %d not found.'),$id));
            }
            else
            {
                  $sql = 'SELECT * FROM '.$this->poll_table.
                         ' WHERE poll_blog = \''.$this->db->escape($this->blog_id).'\''.
                         ' AND poll_id = \''.$this->db->escape($id).'\'';

                  $sql .= $this->getSQLFilter();
                  $record = $this->db->select($sql);

                  if($record->count() != 1)
                        throw new Exception(sprintf(__('Poll identified by %d not found.'),$id));
                  
                  $this->config->setNameSpace('system');

                  
                  $poll                    = new dcDotpoll($this->core);
                  $poll->title             = $record->poll_title;
                  $poll->id                = $record->poll_id;
                  $poll->author            = $record->poll_user;
                  $poll->status            = $record->poll_status;
                  $poll->cdate             = dt::str($this->config->date_format,
                                                     $record->poll_cdate);
                  $poll->progressbar       = $record->poll_progressbar;
                  $poll->progressbar_color = $record->poll_progressbar_color;
                  $poll->percentage        = $record->poll_percentage;
                  $poll->percentage_color  = $record->poll_percentage_color;
                  
                  $this->polls[$record->poll_id] = $poll;
                  
                  return $poll;
            }
      }
      
      public function pollsCount()
      {
            $this->loadPolls();
            return count($this->polls);
      }
      
      public function addFilter($field,$values)
      {
            if(is_array($values))
                  foreach($values as $k => $v)
                        $values[$k] = $this->db->escape($v);
            else
                  $values = $this->db->escape($values);
            $this->filters[$field] = $values;
      }
      
      private function getSQLFilter()
      {
            $sql = '';
            foreach($this->filters as $field => $values)
            {
                  $sql .= 'AND '.$field;
                  if(!is_array($values))
                       $sql .= ' = \''.$values.'\'';
                  else
                  {
                        $sql .= ' IN (\''.implode('\',\'',$values).' \')';
                  }
            }
            return $sql;
      }
      
      public function loadPolls()
      {
            if($this->pollsLoaded) return true;

            $sql = 'SELECT * FROM '.
                   $this->poll_table.
                   ' WHERE poll_blog = \''.
                   $this->db->escape($this->blog_id).'\' ';

            $sql .= $this->getSQLFilter();
            
            $record = $this->db->select($sql);
            if($record->count()==0)
                  return true;
            while($record->fetch())
            {
                  $poll                    = new dcDotpoll($this->core);
                  $poll->title             = $record->poll_title;
                  $poll->id                = $record->poll_id;
                  $poll->author            = $record->poll_user;
                  $poll->status            = $record->poll_status;
                  $poll->cdate             = dt::str($this->config->date_format,
                                                     $record->poll_cdate);
                  
                  $this->polls[$record->poll_id] = $poll;
            }

            $this->pollsLoaded = true;
            return true;
      }
}
?>
