<?php
// Direct access denied
if (!defined('DC_CONTEXT_ADMIN')) {
        exit;
}

// Html manager
require(dirname(__FILE__).'/class/class.dc.dotpoll.html.php');

// Plugin name
$p_name = __('DotPoll');

// New Html manager
$html = new dcDotpollHtml($core,$p_url,$p_name);

// New poll manager
$manager = new dcDotPolls($core);

// Initializing messages and errors
$messages = array();
$errors = array();

// Read get value
$action   = (isset($_REQUEST['action']))?$_REQUEST['action']:'';
$pollId   = (isset($_REQUEST['pollid']))?$_REQUEST['pollid']:-1;
$msg      = (isset($_REQUEST['msg']))?$_REQUEST['msg']:-1;
$optionId = (isset($_REQUEST['optionid']))?$_REQUEST['optionid']:-1;

switch ($msg)
{
      case 0:
            $html->addMessage(__('New poll saved'));
            break;
      case 1:
            $html->addMessage(__('Polls removed'));
            break;
      case 2:
            $html->addMessage(__('Poll removed'));
            break;
      case 3:
            $html->addMessage(__('Poll updated'));
            break;
      case 4:
            $html->addMessage(__('Options removed'));
            break;
      case 5:
            $html->addMessage(__('Option saved'));
            break;
      case 6:
            $html->addMessage(__('Configuration saved'));
            break;
      case 7:
            $html->addMessage(__('Polls status updated'));
            break;
      case 8:
            $html->addMessage(__('Option updated'));
            break;
      case 9:
            $html->addMessage(__('Options order saved.'));
            break;
      case 10:
            $html->addMessage(__('Results reseted.'));
            break;
}

switch($action)
{
      // Wiev / edit option
      case 'wievoption':
            try
            {
                  $poll = $manager->getPoll($pollId);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  break;
            }
            if(!empty($_POST['option']))
            {
                  $poll->updateOption($optionId,$_POST['option']);
                  http::redirect($p_url.'&action=wievpoll&pollid='.$pollId.'&msg=8');
            }
            $option = array($optionId,$poll->options[$optionId]);
            
            $html->addLocation(array($p_url.'&action=wievpoll&pollid='.$poll->id,
                                     $poll->title));
            $html->addLocation(__('Option'));
            $html->optionPage($poll,$option);
            break;


      // Clear results
      case 'clearreasults':
            try
            {
                  $poll = $manager->getPoll($pollId);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  break;
            }
            if(isset($_POST['reset']))
            {
                  $poll->clearResult();
                  http::redirect($p_url.'&action=wievpoll&pollid='.$pollId.'&msg=10');
            }
            break;

      // Save configuration
      case 'saveconfig':
            if(!empty($_POST['save']))
            {
                  $manager->dotpoll_cookie_id = (isset($_POST['cookieid']))?true:false;
                  $manager->dotpoll_ip_id     = (isset($_POST['ipid']))?true:false;
                  http::redirect($p_url.'&action=saveconfig&msg=6');
            }
            $html->setDefaultTab('config');
            $html->homePage($manager);
            break;
            
      // Add poll option
      case 'addoption':
            try
            {
                  $poll = $manager->getPoll($pollId);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  break;
            }
            if(!empty($_POST['option']))
            {
                  $poll->addOption($_POST['option']);
                  http::redirect($p_url.'&msg=5&action=addoption&pollid='.$poll->id);
            }
            $html->addLocation($poll->title);
            $html->setDefaultTab('newoption');
            $html->pollPage($poll);
            break;
            
      // Update poll options
      case 'updateoption':
            try
            {
                  $poll = $manager->getPoll($pollId);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  break;
            }
            if(isset($_POST['delete']) && !empty($_POST['option']))
            {
                  if(is_array($_POST['option']))
                  {
                        foreach($_POST['option'] as $op)
                              $poll->removeOption($op);
                  }
                  else
                        $poll->removeOption($_POST['option']);
                  http::redirect($p_url.'&msg=4&action=updateoption&pollid='.$poll->id);
            }
            else if(isset($_POST['saveorder']))
            {
                  if(!empty($_POST['options_order']))
                  {
                        $order = explode(',',$_POST['options_order']); $i=1;
                        foreach($order as $op)
                              if(!empty($op)) $poll->setOptionOrder($op,$i++);
                  }
                  else if(!empty($_POST['order']))
                  {
                        foreach($_POST['order'] as $id => $order)
                              $poll->setOptionOrder($id,$order);
                  }
                  http::redirect($p_url.'&msg=9&action=updateoption&pollid='.$poll->id);
            }
            $html->addLocation($poll->title);
            $html->setDefaultTab('optionslist');
            $html->pollPage($poll);
            break;

      // Publish / Unpublish poll
      /*
      Useless, disabled in this version.
      case 'publish':
      case 'unpublish':
            if(is_array($_POST['poll']))
            {
                  $manager = new dcDotpolls($core);
                  foreach($_POST['poll'] as $poll)
                  {
                        try
                        {
                              $poll = $manager->getPoll($poll);
                        }
                        catch(Exception $e)
                        {
                              $core->error->add($e->getMessage());
                              continue;
                        }
                        $poll->status = ($action=='publish')?1:0;
                        $poll->save();
                  }
                  http::redirect($p_url.'&msg=7');
            }
            http::redirect($p_url);
            break;
      */

      // Update poll
      case 'update':
            if(!empty($_POST['title']))
            {
                  try
                  {
                        $poll = $manager->getPoll($pollId);
                  }
                  catch(Exception $e)
                  {
                        $core->error->add($e->getMessage());
                        break;
                  }
                  $poll->title = $_POST['title'];
                  $poll->save();
                  http::redirect($p_url.'&msg=3&action=wievpoll&pollid='.$poll->id);
            }

      // Wiev poll
      case 'wievpoll':
            try
            {
                  $poll = $manager->getPoll($pollId);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  break;
            }
            $html->addLocation($poll->title);
            if($msg == 8)$html->setDefaultTab('optionslist');
            else $html->setDefaultTab('pollinfos');
            $html->pollPage($poll);
            break;

      // New poll
      case 'add':
            if(!empty($_POST['title']))
            {
                  $poll = new dcDotpoll($core);
                  $poll->title  = $_POST['title'];
                  $poll->status = 1;
                  $poll->save();
                  http::redirect($p_url.'&msg=0&action=wievpoll&pollid='.$poll->id);
            }
            $html->setDefaultTab('newpoll');
            $html->homePage($manager);
            break;  

      // Remove poll
      case 'remove':
            if(!empty($_POST['poll']))
            {
                  if(is_array($_POST['poll']))
                  {
                        foreach($_POST['poll'] as $poll)
                        {
                              try
                              {
                                    $poll = $manager->getPoll($poll)->remove();
                              }
                              catch(Exception $e)
                              {
                                    $core->error->add($e->getMessage());
                                    break;
                              }
                        }
                        http::redirect($p_url.'&msg=1');
                  }
                  else
                  {
                        try
                        {
                              $poll = $manager->getPoll($_POST['poll'])->remove();
                        }
                        catch(Exception $e)
                        {
                              $core->error->add($e->getMessage());
                              break;
                        }
                        http::redirect($p_url.'&msg=2');
                  }
            }
      
      // Default : Show poll list
      default:
            $html->setDefaultTab('pollslist');
            $html->homePage($manager);
            break;
}
?>
