<?php
if (!defined('DC_CONTEXT_ADMIN')) { return; }

$name = 'randomPost';

# Get versions
$this_version = $core->plugins->moduleInfo($name, 'version');
$installed_version = $core->getVersion($name);

# Compare versions
if (version_compare($installed_version, $this_version, '>=')) {
	return;
}

# Install or update
try
{
	# Check DC version
	if (!version_compare(DC_VERSION, '2.2', '>='))
	{
		throw new Exception(sprintf(__('Plugin %1$s version %2$s requires Dotclear 2.2 or later.'), $name, $this_version));
	}

	//... ici ce qu'on veut faire pendant l'installation. (ou même rien)
	// Install default values for the settings if they don't exist yet
	if ($core->blog->settings->randomPost == null) {
		$core->blog->settings->addNamespace('randomPost');
		$core->blog->settings->randomPost->put('randomPostURL', 'random', 'string', 'Prefix for the URL redirecting to a random post', true, true);
		$core->blog->settings->randomPost->put('randomPostStaticURL', 'randomPost', 'string', 'Prefix for the URL displaying a random post', true, true);
	}

	$core->setVersion($name, $this_version);

	return true;
}
catch (Exception $e)
{
	$core->error->add($e->getMessage());
	return false;
}