<?php
if (!defined('DC_RC_PATH')) { return; }

require dirname(__FILE__).'/_widget.php';

$core->tpl->addValue('RandomRedirURL',array('tplRandomPost','tplRandomRedirURL'));
$core->tpl->addValue('RandomStaticURL',array('tplRandomPost','tplRandomStaticURL'));

$core->tpl->addBlock('RandomPost',array('tplRandomPost','tplRandomPostBlock'));
$core->tpl->addValue('RandomPostURL',array('tplRandomPost','tplRandomPostURL'));
$core->tpl->addValue('RandomPostTitle',array('tplRandomPost','tplRandomPostTitle'));
$core->tpl->addValue('RandomPostExcerpt',array('tplRandomPost','tplRandomPostExcerpt'));

class urlRandomPost extends dcUrlHandlers {
	public static function redirRandomPost($args)
	{
		$args = trim($args, '/');
		if ($args == '') {
			$args = randomPost::allCatID;
		}
		$randomPost = new randomPost($GLOBALS['core']->blog,false,$args);

		// Get the URL of the post, and redirect to it
		http::head(302,'Found');
		header('Location: '.$randomPost->getURL());
		exit;
	}

	public static function staticRandomPost($args)
	{
		$_ctx =& $GLOBALS['_ctx'];
		$core =& $GLOBALS['core'];

		$args = trim($args, '/');
		if ($args == '') {
			$args = randomPost::allCatID;
		}
		$randomPost = new randomPost($core->blog,false,$args);

		// Get the URL of the post and all associated info
		$params['post_url'] = $randomPost->getPostURL();
		$_ctx->posts = $core->blog->getPosts($params);
		if ($_ctx->posts->isEmpty())
		{
			# No entry
			self::p404();
		}

		// Prevent the display of the comments form
		$core->blog->settings->system->allow_comments = false;

		// Display the post
		self::serveDocument('post.html', 'text/html', false, false);
	}
}

class tplRandomPost {
	public static function tplRandomPostBlock($attr, $content)
	{
		$categoryID = isset($attr['limit_to_category_id']) ? $attr['limit_to_category_id'] : randomPost::allCatID;
		return '<?php $_ctx->randomPost = new randomPost($core->blog,true,"'.$category_id.'"); ?>'.
			$content.
			'<?php unset($_ctx->randomPost); ?>';
	}

	public static function tplRandomPostTitle($attr)
	{
		return '<?php echo context::global_filter($_ctx->randomPost->getPostTitle(),1,1,0,0,0); ?>';
	}

	public static function tplRandomPostURL($attr)
	{
		return '<?php echo $_ctx->randomPost->getPostURL(); ?>';
	}

	public static function tplRandomPostExcerpt($attr)
	{
		$max_length = isset($attr['max_length']) ? $attr['max_length'] : 200;
		return '<?php if ($_ctx->randomPost->getPost()->isExtended()) {'.
			' $excerpt = $_ctx->randomPost->getPost()->getExcerpt();'.
			' } else {'.
			' $excerpt = $_ctx->randomPost->getPost()->getContent();'.
			' }'.
			' if ('.$max_length.' > 0 && strlen($excerpt) > '.$max_length.') {'.
			' $excerpt = substr($excerpt, 0, '.$max_length.');'.
			' $excerpt = substr($excerpt, 0, strrpos($excerpt, " "))." ...";'.
			' }'.
			' echo $excerpt; ?>';
	}

	public static function tplRandomRedirURL($attr)
	{
		$categoryID = isset($attr['limit_to_category_id']) ? '/'.$attr['limit_to_category_id'] : '';
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("randomPost")."'.$categoryID.'"').'; ?>';
	}

	public static function tplRandomStaticURL($attr)
	{
		$categoryID = isset($attr['limit_to_category_id']) ? '/'.$attr['limit_to_category_id'] : '';
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("randomStaticPost")."'.$categoryID.'"').'; ?>';
	}

	public static function randomPostWidget(dcWidget $w)
	{

		global $core;

		if ($w->offline)
			return;

		if (($w->homeonly == 1 && $core->url->type != 'default') ||
			($w->homeonly == 2 && $core->url->type == 'default')) {
			return;
		}

		$title = $w->title ? html::escapeHTML($w->title) : __('Random post');
		$res = '';
		if ($w->redirect) {
			$res .= '<ul><li><a href="'.$core->blog->url.$core->url->getBase('').'random';
			if ($w->category != randomPost::allCatID) {
				$res .= '/'.$w->category;
			}
			$res .= '">'.$title.'</a></li></ul>';
		} else {
			$randomPost = new randomPost($core->blog, $w->excerpt, $w->category);
			$res .= '<h3>'.$title.'</h3>' .
				'<p class="randomPostTitle">';
			$res .= '<a href="'.$randomPost->getPostURL().'">'.
				html::escapeHTML($randomPost->getPostTitle()).'</a>';
			$res .= '</p>';
			if ($w->excerpt) {
				if ($randomPost->getPost()->isExtended()) {
					$excerpt = $randomPost->getPost()->getExcerpt();
				} else {
					$excerpt = $randomPost->getPost()->getContent();
				}
				$excerpt = strip_tags($excerpt, $w->allowed_tags);
				$excerpt = preg_replace('/\s+/',' ',$excerpt);
				if ($w->max_length > 0 && strlen($excerpt) > $w->max_length) {
					$excerpt = substr($excerpt, 0, $w->max_length);
					$excerpt = substr($excerpt, 0, strrpos($excerpt, ' ')).' ...';
				}
				$res .= '<p>'.$excerpt.'</p>';
			}
		}

		return $w->renderDiv($w->content_only,'randompost '.$w->class,'',$res);
	}
}
