<?php
if (!defined('DC_RC_PATH')) { return; }

$core->addBehavior('initWidgets',array('randomPostBehaviors','initWidget'));

require(dirname(__FILE__).'/class.randomPost.php');

class randomPostBehaviors {
	public static function initWidget(dcWidgets $w)
	{
		$w->create('randomPost',__('RandomPost'),array('tplRandomPost','randomPostWidget'),
			null,
			__('Link to a random ticket'));
		$w->randomPost->setting('title',__('Title:'),__('Random post'));
		$w->randomPost->setting('redirect',__('Use redirection'),1,'check');
		$w->randomPost->setting('excerpt',__('Display an excerpt from the post'),0,'check');
		$w->randomPost->setting('max_length',__('Excerpt maximum length (in characters)'),200);
		$w->randomPost->setting('allowed_tags',__('HTML tags allowed in the output'),'');

		// Get a list of categories in a combo box
		try {
			$rs = $GLOBALS['core']->blog->getCategories();
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
		$categories = array(__('All categories') => randomPost::allCatID);
		while ($rs->fetch())
		{
			$categories = array_merge($categories, array(html::escapeHTML($rs->cat_title) => $rs->cat_id));
		}
		$w->randomPost->setting('category',__('Restrict to category'),'none','combo',$categories);
		$w->randomPost->setting('homeonly',__('Display on:'),0,'combo',
			array(
				__('All pages') => 0,
				__('Home page only') => 1,
				__('Except on home page') => 2
				)
		);
    $w->randomPost->setting('content_only',__('Content only'),0,'check');
    $w->randomPost->setting('class',__('CSS class:'),'');
		$w->randomPost->setting('offline',__('Offline'),0,'check');
	}
}