<?php
if (!defined('DC_CONTEXT_ADMIN')) { exit; }

$page_title = __('Random Post plugin');

if (!$core->blog->settings->randomPost->randomPost_category) {
	try
	{
		$core->blog->settings->addNameSpace('randomPost');
		$core->blog->settings->randomPost->put('randomPost_category', randomPost::allCatID, 'text', 'Category limitation when selecting a random post (only from template functions)');
		if ($core->blog->settings->randompost->randompost_category) {
			// Backport the setting value from the previously incorrectly named namespace
			$core->blog->settings->randomPost->randomPost_category = $core->blog->settings->randompost->randompost_category;
			$core->blog->settings->randompost->drop('randompost_category');
		}
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}
?>
<html>
<head>
  <title><?php echo($page_title); ?></title>
</head>
<body>
<?php
	echo dcPage::breadcrumb(
		array(
			html::escapeHTML($core->blog->name) => '',
			'<span class="page-title">'.$page_title.'</span>' => ''
		));
?>
<div class="fieldset">
<h3><?php echo __('Usage');?></h3>
<p><?php echo sprintf(__("In your template, just create a link with %s as a destination. When your visitors'll click on that link, they'll be redirect to a random post from your blog."), '<kbd>{{tpl:RandomRedirURL}}</kbd>'); ?></p>
<p><?php echo sprintf(__("Or, if you prefer, you can also use it as a widget. The link will be enclosed in a %s with class %s and displayed as a %s."), '<kbd>&lt;div&gt;</kbd>', '<kbd>randompost</kbd>', '<kbd>&lt;li&gt;</kbd>'); ?></p>
<h4><?php echo __('Advanced usage');?></h4>
<p class="info"><?php echo __('I advise you strongly <strong>not</strong> to use these advanced techniques on every page of your blog.').' '.
__("Doing so will result in two more SQL requests for every page views, which might slow down your site to a crawl. You've been warned.");?></p>
<p><?php echo __('You can display both an excerpt and the title from the post, either with the widget options or the template functions.');?></p>

<h4><?php echo __('Using the widgets options:');?></h4>
<dl>
  <dt><?php echo __('Title:');?></dt><dd><?php echo __('Title of the block displayed in the sidebar, or link text if you use redirection.');?></dd>
  <dt><?php echo __('Use redirection');?></dt><dd><?php echo sprintf(__('Use a %s URL for redirection.'), '<kbd>/random</kbd>').' '.__('This is the prefered method, as the needed database requests will only be executed when your users click on the link.');?></dd>
  <dt><?php echo __('Display an excerpt from the post');?></dt><dd><?php echo __("Will display the excerpt from the post, or the post's content if there's no excerpt.");?></dd>
  <dt><?php echo __('Excerpt maximum length (in characters)');?></dt><dd><?php echo __('Limit the displayed excerpt to a certain maximum length. Use 0 if you want to display the full excerpt.');?></dd>
  <dt><?php echo __('HTML tags allowed in the output');?></dt><dd><?php echo sprintf(__("Specify the HTML tags you want to allow in the excerpt. You can put multiple tags, for example: %s"), '<kbd>&lt;img&gt;&lt;a&gt;</kbd>');?></dd>
  <dt><?php echo __('Home page only');?></dt><dd><?php echo __('Display the link to the random post only on the home page.');?></dd>
  <dt><?php echo __('Restrict to category');?></dt><dd><?php echo __('With this option, you can restrict the posts to one category only.').' '.__('Choose "All categories" if you don\'t want this limit.');?></dd>
</dl>
<h4><?php echo __('Using the template functions:');?></h4>
<dl>
  <dt><kbd>{{tpl:RandomRedirURL}}</kbd></dt><dd><?php echo __('Use this function as the destination of a link.').' '.__('This is the prefered method, as the needed database requests will only be executed when your users click on the link.');?></dd>
  <dt><kbd>&lt;tpl:RandomPost&gt;</kbd></dt><dd><?php echo __('Start of a template block. It selects a random post, which can then be accessed and displayed with the next functions.');?></dd>
  <dt><kbd>{{tpl:RandomPostURL}}</kbd></dt><dd><?php echo __('Returns the URL of the selected post.');?></dd>
  <dt><kbd>{{tpl:RandomPostTitle}}</kbd></dt><dd><?php echo __('Returns the title of the selected post.');?></dd>
  <dt><kbd>{{tpl:RandomPostExcerpt}}</kbd></dt><dd><?php echo __("Returns the excerpt (or content it there's no excerpt) of the selected post.").' '.
  sprintf(__('Can take one attribute, %s, which indicates the maximum length for the excerpt displayed.'), '<kbd>max_length</kbd>').' '.
  sprintf(__('Use 0 for %s to disable this truncation (the default is 200 characters).'), '<kbd>max_length</kbd>');?></dd>
</dl>

<p><?php echo sprintf(__('Both the %s and %s template functions can take one attribute: %s.'),'<kbd>&lt;tpl:RandomPost&gt;</kbd>','<kbd>{{tpl:RandomRedirURL}}</kbd>','<kbd>limit_to_category_id</kbd>').' '.
__('This attribute takes a numeric value: the ID of a category.').' '.__('If you use that attribute, all the posts randomly selected will belong to the given category.');?></p>
<p class="info"><?php echo __('In the widget, the options "Use redirection" and "Display an excerpt from the post" are mutually exclusive.').
' '.__('If you check both boxes, the option "Use redirection" will take precedence.'); ?></p>
</div>
</body>
</html>